
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Mar 29 11:40:39 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_AuthenticatorsTstVectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */ 
/************* Include Files ***********************************/
#include "SST_TST.h"
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*******************************************/
/* Password Authenticator object Test data */
/*******************************************/
TST_ATP_PassAuthTestDataStruct TST_ATP_PassAuthObjectTestData[]=
{
    {
        /*TST_Name*/
        {"ATP test PassAuthObject-15 byte then 36 byte passwords"},
        /*TST_MasterPassword*/
        {0x00,0x86,0xb2,0xe9,0x41,0xb4,0x96,0x30,0xd2,0x0b,0xb5,0xa5,0x37,0xcf,0xd2},
        /*TST_MasterPasswordSizeInBytes*/
        15,
        /*TST_MasterMaxNumOfTrials*/
        2,
        /*TST_SecondaryPassword*/
        {0x0e,0x58,0xbd,0xf1,0x9e,0x6b,0x76,0x34,0xcd,0x39,0x3b,0x8e,0xff,0x21,0x47,0x62,
        0xdb,0xc1,0x0c,0x69,0x0a,0xae,0x19,0x01,0x3b,0x68,0x41,0xc8,0x6b,0x8d,0xfa,0x6a,
        0x5a,0x95,0x9c,0x92,0xfd,0x8a,0x66,0x79,0xb5,0x53},
        /*TST_SecondaryPasswordSizeInBytes*/
        32,
        /*TST_SecondaryMaxNumOfTrials*/
        3,
    /*TST_NewSecondaryPassword*/
    {0xf6,0x40,0x40,0x57,0xc3,0x9a,0x35,0xb2,0x3e,0xc4,0x20,0xf2,0xba,0xda,0x82,0x21,
    0x6a,0x51,0xc9,0x87,0xc6,0xd0,0xd2,0x1f,0x30,0x41,0xab,0x47,0xd8,0x29,0x9d,0xbb,
    0xdd,},
    /*TST_NewSecondaryPasswordSizeInBytes*/
    33,
    /*TST_NewSecondaryMaxNumOfTrials*/
    7,
        /*TST_Data*/
    {0x93,0xea,0xa0,0x76,0x80,0x75,0x4f,0xc3,0xca,0x3b,0x4a,0x2a,0xd4,0xa9,0x9d,0x93,
    0xad,0x1e,0x7f,0x6e,0xd9,0x9d,0x32,0x02,0x55,0xc6,0x2b,0x02,0xd5,0x04,0x73,0x62,
    0x50,0x07,0x4d,0x68,0xbe,0x75,0x19,0x06,0x21,0xdc,0x78,0x67,0xc2,0xec,0xb1,0xc8,
    0xbd,0xe3,0x54,0x89,0xbf,0x48,0x1d,0x84,0x0f,0xdc,0x1a,0x9d,0xcb,0xce,0x10,0x9a,
    0x75,0x2e,0x1c,0x36,0xae,0xa4,0x96,0x70,0x40,0x62,0x3a,0x29,0x62,0x57,0x8a,0xee,
    0x38,0xa5,0x6e,0x13,0x9a,0x56,0x1e,0x01,0x16,0x4a,0x41,0xd0,0x38,0x74,0x57,0x19,
    0x08,0x47,0x54,0x05,0xd5,0x6a,0x8d,0xaa,0x31,0xb3,0xd8,0x98,0x3d,0x53,0xef,0xae,
    0x27,0x4e,0x16,0x33,0xf0,0x2f,0xfe,0x22,0x73,0xf9,0xe8,0xc4,0xa3,0x60,0x0d,0x84,
    0x14,0x39,0x3e},
        /*TST_DataSize*/
    131,
    },
#if TST_USE_AUTHENTICATOR_MODULE
    {
        /*TST_Name*/
        {"ATP test PassAuthObject-15 byte then 1514 byte passwords"},
        /*TST_MasterPassword*/
        {0x00,0x86,0xb2,0xe9,0x41,0xb4,0x96,0x30,0xd2,0x0b,0xb5,0xa5,0x37,0xcf,0xd2},
        /*TST_MasterPasswordSizeInBytes*/
        15,
        /*TST_MasterMaxNumOfTrials*/
        2,
        /*TST_SecondaryPassword*/
        {0x0e,0x58,0xbd,0xf1,0x9e,0x6b,0x76,0x34,0xcd,0x39,0x3b,0x8e,0xff,0x21,0x47,0x62,
        0xdb,0xc1,0x0c,0x69,0x0a,0xae,0x19,0x01,0x3b,0x68,0x41,0xc8,0x6b,0x8d,0xfa,0x6a,
        0x63,0x4c,0x03,0xb7,0x82,0x1d,0x4a,0xf9,0xbc,0xaf,0x0c,0x84,0xe3,0x22,0x3e,0x8e,
        0x25,0x77,0x2c,0x41,0xd7,0x45,0x60,0x0f,0x71,0xad,0xc5,0x46,0xd9,0x8f,0x0c,0xe4,
        0xe4,0xfe,0x4f,0xac,0x1a,0xf2,0xf4,0x79,0xb9,0x3d,0xd5,0xd3,0xfd,0xc1,0x9d,0xc0,
        0x9f,0xdf,0x75,0xdc,0x9b,0x33,0xe1,0xac,0x37,0x7e,0xe4,0x30,0x41,0xe3,0x6b,0xb7,
        0x98,0x57,0xe9,0xf7,0xee,0x53,0x3e,0x5d,0xcb,0xcb,0xdd,0xa2,0xd5,0x64,0x2e,0x9f,
        0x50,0xe2,0x31,0x62,0xe1,0xdf,0x65,0x81,0x97,0xc3,0xe8,0xae,0x2b,0xf0,0xdf,0x8c,
        0x87,0x3d,0x18,0xc2,0x86,0xa6,0xee,0x4d,0xfb,0x42,0x6d,0x1a,0xf4,0x75,0xb7,0xd4,
        0x40,0x66,0xa6,0xfb,0x2e,0xb3,0xb3,0x36,0x98,0x64,0x17,0xea,0x20,0x1e,0x30,0x0b,
        0xba,0x99,0x25,0x32,0x6b,0x54,0xcd,0xf0,0x50,0x88,0xcd,0x63,0xe1,0x5a,0x01,0x06,
        0x77,0x54,0x1e,0xcd,0x0c,0x16,0x95,0x72,0x42,0x49,0xba,0x09,0xa7,0xd5,0x25,0xdb,
        0x38,0x54,0x58,0x71,0x24,0xc6,0xa3,0xef,0xd2,0x86,0x45,0xa4,0x24,0x7d,0xd4,0xde,
        0xfe,0x95,0xdf,0x03,0x02,0x70,0xd1,0xdd,0x9e,0x5b,0x18,0x36,0x49,0x7d,0x87,0xa5,
        0x09,0x54,0xf9,0xa7,0x39,0x63,0x38,0xf1,0x89,0x24,0x1d,0x05,0x46,0x44,0xf8,0x04,
        0xdc,0x0f,0x31,0xc3,0x99,0x2a,0x30,0x20,0xb3,0x80,0x7b,0x97,0x8d,0x7e,0x1e,0x10,
        0x36,0x83,0x50,0xfb,0x32,0x92,0x53,0x9f,0x7e,0x4b,0x9c,0xaf,0xce,0x19,0x34,0x1f,
        0x19,0xac,0x5e,0x35,0x57,0xaa,0x7a,0xe3,0x8a,0xa1,0x29,0x54,0xfb,0x41,0xb2,0xc5,
        0xc6,0xc8,0xa5,0x96,0x98,0xbd,0xbe,0xa1,0xb8,0xe1,0x0b,0xca,0x44,0x63,0x51,0xd7,
        0xbe,0x53,0xad,0x83,0xc7,0x59,0x77,0xcd,0x29,0xa7,0x6b,0x96,0x1b,0x2c,0x0b,0x6b,
        0xc1,0x0a,0x3f,0xa0,0xf3,0x4b,0x3f,0x9e,0x3f,0xcf,0xb2,0x7d,0x31,0x89,0x18,0xd6,
        0xd1,0xec,0x65,0xd2,0x6e,0x9f,0xee,0x87,0x9a,0x78,0x89,0x85,0x76,0xa8,0xf0,0xab,
        0x30,0x33,0x67,0x40,0xc9,0xa4,0x9f,0x3f,0x1c,0xfe,0xd9,0xf1,0x1c,0xf5,0x4e,0xc1,
        0x5d,0x5e,0xcf,0x4d,0xd6,0xe5,0xa9,0xb9,0xe5,0xfe,0xcb,0x48,0x93,0x1e,0x2b,0x2d,
        0x1a,0x2a,0x65,0x9e,0xa4,0x30,0xa5,0x2b,0x56,0x55,0xc8,0x4e,0x8d,0x0e,0xbe,0x43,
        0x67,0x93,0x33,0x19,0x86,0x91,0x6e,0x0a,0x10,0x1f,0x79,0x08,0xfa,0xf4,0x82,0x98,
        0x87,0xd7,0x81,0xe3,0x0b,0x56,0x1b,0x0a,0xf5,0xbb,0xc6,0xbb,0x0c,0x3c,0x2f,0x02,
        0xf9,0x72,0xd9,0x61,0x06,0x0d,0x06,0x22,0x25,0xc5,0xda,0xec,0x34,0x94,0xbe,0x95,
        0x7f,0x22,0x03,0x37,0x87,0x81,0xc7,0x86,0x02,0x1a,0x1d,0x60,0x22,0xe7,0x68,0xa6,
        0x1a,0xe3,0x08,0x4b,0xdf,0xbf,0x39,0xaa,0x2b,0xd7,0x37,0x1d,0xc8,0x64,0xa7,0xcb,
        0x0b,0xf3,0x32,0xc1,0x9f,0x16,0x73,0x45,0x83,0x59,0x13,0x66,0x56,0x77,0x32,0xd8,
        0xd3,0xce,0x09,0xff,0x98,0x11,0xce,0x4a,0x2b,0x3d,0xd8,0xc2,0x3e,0xce,0x04,0xe3,
        0x32,0x32,0x57,0xaa,0xdb,0x7e,0xe5,0xef,0x83,0x60,0xf1,0xf5,0x31,0x54,0x55,0x40,
        0x2b,0x1b,0x25,0xa6,0xb9,0x6a,0x8f,0xa9,0x2c,0xdf,0x05,0x04,0x1f,0x38,0x9f,0x84,
        0xfd,0xc7,0xba,0x19,0xc3,0x21,0xe6,0x2d,0x07,0x17,0xff,0x34,0x3a,0xe7,0x99,0x85,
        0x2a,0xb3,0xa1,0x68,0xca,0x31,0x42,0x70,0x36,0xa5,0x06,0x0b,0xf2,0x0c,0x3e,0x57,
        0x72,0x9a,0xa3,0x37,0xe0,0x67,0x3d,0xa7,0x19,0x66,0x84,0x4c,0xf9,0x96,0xc6,0x4f,
        0xd8,0x7c,0xc8,0x6c,0x54,0xd0,0xb0,0x46,0x51,0x77,0x22,0xfe,0x3f,0xb1,0xaa,0x03,
        0x9c,0x94,0x5a,0x2c,0xb9,0xb9,0xb4,0x04,0xc0,0x35,0xca,0x65,0xf6,0xca,0xa3,0x48,
        0x3e,0x5f,0xe1,0xdb,0xdf,0xae,0xa1,0xd4,0x86,0x3d,0xa3,0x05,0x8f,0x8f,0xab,0x31,
        0x80,0x9b,0x26,0x1f,0xd6,0x7d,0x11,0xec,0x05,0x6c,0x17,0xa5,0xba,0xec,0xf9,0x16,
        0x63,0x44,0x33,0xdc,0xf1,0x33,0xdd,0xc2,0xdc,0xdf,0xcf,0x4a,0x68,0x0e,0x08,0x89,
        0x28,0x98,0x51,0x38,0xc0,0x1d,0x1d,0x09,0xee,0xf3,0xb4,0x37,0xcc,0x62,0x90,0x61,
        0x4f,0x14,0x07,0x98,0x14,0xc7,0x2b,0xb7,0x5c,0x45,0xef,0xf2,0x55,0x96,0x8b,0xb2,
        0x9b,0x74,0x21,0xa1,0xfe,0xff,0xa0,0x00,0x86,0xb2,0xe9,0x41,0xb4,0x96,0x30,0xd2,
        0x0b,0xb5,0xa5,0x37,0xcf,0xd2,0x54,0x5b,0x0d,0x57,0x4a,0x28,0xdb,0x8f,0xfa,0x55,
        0xe1,0x15,0xdf,0x7f,0x18,0x8d,0x62,0x7c,0xd2,0x91,0xfd,0xec,0xfb,0xee,0xa1,0x10,
        0x9e,0x11,0x55,0xe0,0xaa,0xbc,0x21,0x57,0xf7,0xfe,0x2a,0x12,0x84,0x61,0x1e,0x19,
        0x03,0x65,0xd2,0xfd,0x97,0x2d,0x2a,0x23,0xdc,0x79,0x3a,0x5f,0x28,0xd4,0xaa,0xc4,
        0x10,0x0f,0x5f,0xbb,0x2e,0xed,0x57,0x53,0x22,0x20,0xd5,0xd8,0xd7,0x74,0xbf,0xa7,
        0x08,0x4b,0x44,0x40,0x02,0x49,0xc1,0x9d,0xab,0x50,0xe6,0xc3,0xc3,0xaf,0x15,0x96,
        0x6a,0x96,0x0a,0xf1,0xe2,0xce,0xc1,0xf6,0x97,0xa6,0x94,0xa3,0x5c,0x31,0xa5,0xa6,
        0xf8,0xae,0x7b,0x73,0xe1,0x48,0xf0,0x93,0x47,0x00,0x4a,0x3f,0x54,0xe7,0xa8,0x2d,
        0xb3,0x90,0xa0,0xaa,0x4f,0xc5,0x26,0xe9,0x5d,0x79,0xaf,0x9b,0x9c,0xfe,0x97,0xbf,
        0xdb,0x78,0xc0,0xbc,0xbd,0x92,0x7d,0xad,0xb9,0x6f,0xae,0xfc,0x64,0xe4,0x2c,0x32,
        0xf3,0xe4,0x67,0x0d,0xfb,0x3b,0x4d,0xd4,0x7c,0x7f,0x6e,0xe7,0x1e,0x44,0x5e,0x9a,
        0xba,0x90,0x5b,0x43,0x1c,0x8f,0x30,0x92,0x08,0x87,0x59,0x21,0x7a,0x0d,0x68,0x4c,
        0x32,0x7a,0xa8,0x43,0x70,0x99,0xff,0x5d,0xfd,0xa2,0x19,0xb0,0x6a,0x6c,0xc2,0xde,
        0x9c,0xde,0x94,0x31,0x89,0xa7,0xd3,0xeb,0x3c,0x2e,0x95,0xd7,0x1f,0xcc,0x26,0x24,
        0x79,0x3a,0xaa,0x73,0x36,0x45,0x04,0x2f,0xe7,0xc9,0xf7,0x1d,0x09,0xdc,0x8b,0x34,
        0x8a,0x4a,0xb3,0xae,0x89,0x42,0x2c,0x5f,0x5e,0x4e,0xa8,0x46,0xda,0x88,0x2c,0x62,
        0xcf,0x0c,0xb7,0xc6,0xd3,0xa9,0x24,0xf0,0x42,0xdc,0x51,0x57,0x82,0xfe,0x81,0x43,
        0x8b,0xbc,0xff,0xe1,0xa6,0xc8,0x05,0x97,0x74,0xce,0xdb,0x95,0x33,0xaa,0x43,0xad,
        0x3d,0xd8,0x15,0x64,0xd1,0x2b,0x27,0x49,0x16,0xc2,0x6f,0x85,0x5d,0x39,0x6c,0xb4,
        0xa7,0x1c,0xc1,0xf3,0x67,0xa1,0x24,0x3a,0x89,0x96,0x76,0xed,0xb2,0x98,0x33,0xad,
        0xca,0x86,0x0d,0x74,0xb8,0x35,0xd4,0xe1,0x6c,0x65,0x99,0xd0,0x23,0xf4,0x13,0x2e,
        0xe6,0x52,0x42,0x0c,0x54,0x35,0x51,0xf1,0xa2,0x8e,0xc1,0x75,0xe0,0xbb,0xc4,0x0b,
        0x7e,0xfe,0xe7,0x1f,0x0e,0x2e,0xf4,0x61,0x4b,0xac,0x17,0x60,0x5b,0x99,0x3f,0x5a,
        0x51,0x46,0xc7,0x52,0xf6,0xec,0x56,0x64,0xc9,0x9e,0x04,0x56,0x44,0x7b,0xbe,0x6f,
        0x61,0x28,0xeb,0x8c,0x5d,0x7e,0x4f,0x70,0xbc,0x7f,0x30,0x5c,0x8d,0x8f,0xb8,0xdf,
        0xef,0xe1,0x9b,0xf0,0xd4,0x2f,0xfa,0x3a,0x05,0xae,0x86,0xb7,0x67,0x41,0xe8,0x80,
        0x7c,0xec,0x61,0xe4,0x2c,0x8c,0xad,0xb7,0xc6,0xc6,0x2e,0xec,0x42,0x3e,0x46,0x67,
        0xc9,0x09,0x05,0x0c,0x77,0x64,0x04,0x1c,0x5f,0xa6,0x90,0xc1,0xcf,0x73,0x0b,0xe7,
        0xd6,0x33,0x90,0x4e,0x04,0xc2,0xd6,0xdd,0x71,0x69,0x57,0x3a,0x00,0x0e,0xb1,0x97,
        0xe5,0xa7,0x4c,0xcf,0x65,0xf5,0x3d,0xb1,0xdd,0x6e,0x6a,0x9b,0x06,0x7b,0xef,0x4c,
        0x77,0xe3,0xc1,0xf3,0x6c,0x87,0x91,0x8b,0xc5,0x51,0xf4,0x6b,0x52,0x67,0xc0,0x19,
        0x4d,0xa4,0xb9,0x60,0x28,0x48,0x6d,0xa2,0x8a,0xee,0x5c,0x6f,0x94,0xbf,0x5c,0x55,
        0x68,0xe6,0x3c,0xfa,0xec,0x43,0xa8,0x69,0xcb,0x64,0x4c,0xaa,0xbd,0xb1,0x3d,0x95,
        0x09,0xe6,0x94,0xe7,0x48,0xc7,0x5c,0x96,0x6b,0x0f,0xae,0x62,0xff,0xa9,0x1a,0xad,
        0xb0,0x22,0x49,0x8c,0x0c,0x5f,0xe1,0x1e,0x8a,0x8b,0xa9,0x1d,0xcb,0x54,0xee,0xb2,
        0x1f,0x57,0x25,0x8e,0x4b,0xd8,0xd1,0x36,0x8a,0xb7,0xa7,0x9e,0xd1,0x9f,0xf0,0xfa,
        0x57,0x81,0x30,0xd1,0x55,0x41,0x05,0x53,0x0a,0xaf,0x51,0xec,0x03,0xb8,0x9b,0x19,
        0x99,0xde,0xb3,0x7b,0xbb,0xe5,0x95,0x2a,0xee,0xcf,0x90,0x4b,0x91,0x0b,0xa8,0xe5,
        0x66,0xea,0x38,0xf0,0x4e,0x52,0xdc,0xaf,0x54,0xb6,0x8d,0x40,0xed,0x45,0x0e,0x72,
        0x7e,0x62,0x88,0xd6,0x1f,0x55,0x71,0x19,0x9f,0x40,0xb1,0x90,0xc8,0x54,0x08,0x15,
        0xe4,0x44,0xaa,0x12,0x80,0xfa,0x2d,0xdb,0x6f,0x8a,0xa5,0x41,0x12,0x64,0x0e,0x64,
        0xd7,0xcd,0xea,0xc8,0x00,0x90,0x2a,0xab,0xa6,0xf0,0x52,0x96,0xfd,0xe2,0xd9,0x33,
        0xd9,0x79,0xce,0x5e,0x71,0xa2,0xc2,0x7e,0x63,0x11,0xe1,0x16,0xf9,0x7b,0x62,0x97,
        0xab,0x06,0x22,0x79,0xe5,0xfe,0x8b,0x89,0x0a,0xc9,0xbb,0x85,0xb8,0x1d,0xe2,0xe6,
        0x4e,0x70,0xec,0xfd,0xab,0xb0,0x61,0x41,0x39,0x35,0x89,0xe8,0x2b,0xf4,0xd3,0xb4,
        0x02,0xf5,0x77,0x10,0x56,0x07,0x5b,0x5b,0xd3,0xb2,0x34,0x84,0x82,0x6d,0xed,0xd7,
        0x49,0x11,0x4c,0x16,0xb6,0x8e,0xd3,0xcc,0xf8,0xdc,0xe4,0xde,0x2e,0x35,0x29,0x63,
        0xe5,0x82,0x33,0xb5,0xdb,0x13,0x61,0xc8,0x09,0x92,0x04,0xbb,0xe1,0x3a,0xc0,0xad,
        0xd5,0x44,0x36,0xd2,0x18,0xa2,0xdf,0xc6,0xa8,0xf0,0x3b,0x21,0x8c,0xa8,0x2c,0x4b,
        0x5a,0x95,0x9c,0x92,0xfd,0x8a,0x66,0x79,0xb5,0x53},
        /*TST_SecondaryPasswordSizeInBytes*/
        1514,
        /*TST_SecondaryMaxNumOfTrials*/
        3,
    /*TST_NewSecondaryPassword*/
    {0xf6,0x40,0x40,0x57,0xc3,0x9a,0x35,0xb2,0x3e,0xc4,0x20,0xf2,0xba,0xda,0x82,0x21,
    0x6a,0x51,0xc9,0x87,0xc6,0xd0,0xd2,0x1f,0x30,0x41,0xab,0x47,0xd8,0x29,0x9d,0xbb,
    0xdd,0x34,0x6a,0xc4,0xb5,0x15,0xd3,0xad,0xce,0x8c,0x5d,0x77,0x75,0xc8,0x55,0xce,
    0xf8,0xf0,0x12,0x3b,0x07,0xfd,0x7a,0x9a,0x60,0xca,0xc8,0xcf,0xac,0x6e,0x8c,0xb5,
    0xa3,0xc9,0xf2,0x57,0x77,0x5d,0x48,0x63,0x70,0x5f,0xbb,0xdb,0xd3,0x0e,0x61,0x0e,
    0x09,0x44,0x7d,0xc7,0xfd,0x4b,0xfe,0xc4,0xc6,0xf1,0x48,0x69,0x86,0xdf,0x37,0xb6,
    0x92,0x26,0x61,0x77,0xd3,0x1b,0x9c,0xba,0x6c,0x65,0xc1,0x86,0x9c,0x54,0xaf,0xca,
    0xe6,0x75,0x92,0x94,0x70,0x63,0x65,0x83,0xaa,0xdf,0xb5,0x7f,0x2f,0x23,0xa8,0xa7,
    0xf0,0x74,0x3f,0x8b,0x8f,0xf7,0xd8,0x9c,0x09,0xc5,0xf7,0xe1,0x98,0x41,0x45,0xeb,
    0xd8,0xaa,0xd9,0x0a,0x28,0xec,0xb7,0xc1,0x53,0xbc,0x96,0x78,0x70,0xe3,0xe7,0x71,
    0x06,0xda,0x12,0xfd,0x74,0x98,0x03,0xf0,0x90,0xa8,0xe5,0x52,0x8f,0x7e,0x2d,0x57,
    0x25,0x0b,0xdb,0x91,0xec,0x8f,0xfc,0x65,0x0a,0xaf,0x74,0xbc,0x0f,0xc7,0xfa,0xfa,
    0x1c,0x81,0x64,0x34,0x4a,0xa7,0x25,0x9e,0x49,0x35,0x14,0x42,0x48,0xb3,0x6f,0xf8,
    0x15,0xc1,0x1f,0x92,0x86,0xf4,0x3d,0x57,0x17,0xe0,0xd6,0xb3,0xd4,0x76,0xeb,0x2c,
    0x7a,0x91,0xbc,0x98,0xd9,0xcb,0x47,0x8d,0x7c,0x95,0x0b,0x1a,0x8c,0x87,0x11,0xb4,
    0xf2,0xf4,0x2d,0x73,0xbc,0xc2,0x82,0x7f,0xc2,0x78,0x44,0xc5,0x89,0x99,0xc2,0xee,
    0x67,0x31,0xa3,0x91,0xe8,0xad,0x6f,0xa7,0x71,0xef,0x52,0x40,0x23,0xa2,0x1d,0x75,
    0x02,0xcb,0x8e,0x9e,0x57,0xa1,0xd1,0xc5,0x53,0x9f,0x46,0x5a,0xf4,0xd7,0x85,0x27,
    0x2d,0x89,0xa0,0x87,0x41,0xf4,0xa8,0xd3,0x70,0x6c,0x72,0x1e,0xd5,0xad,0x9a,0x22,
    0x8f,0x6f,0xc9,0x79,0x1f,0x3b,0x34,0x11,0x11,0x7c,0x65,0xda,0xdf,0xd9,0x3e,0xc1,
    0x12,0xc2,0x3b,0xe2,0xaa,0x49,0xf7,0xf9,0xc0,0x34,0xf2,0x1a,0x6a,0x50,0x91,0xa3,
    0xdf,0x08,0x66,0x6e,0xdb,0x35,0xb2,0x4b,0x45,0x38,0x28,0xad,0x10,0x47,0xf4,0xa3,
    0x5f,0x04,0xfc,0x0a,0xec,0x54,0x66,0x02,0xaa,0x6e,0x5a,0x9e,0xa9,0x32,0x09,0xe0,
    0x3a,0xbd,0xee},
    /*TST_NewSecondaryPasswordSizeInBytes*/
    371,
    /*TST_NewSecondaryMaxNumOfTrials*/
    7,
        /*TST_Data*/
    {0x93,0xea,0xa0,0x76,0x80,0x75,0x4f,0xc3,0xca,0x3b,0x4a,0x2a,0xd4,0xa9,0x9d,0x93,
    0xad,0x1e,0x7f,0x6e,0xd9,0x9d,0x32,0x02,0x55,0xc6,0x2b,0x02,0xd5,0x04,0x73,0x62,
    0x50,0x07,0x4d,0x68,0xbe,0x75,0x19,0x06,0x21,0xdc,0x78,0x67,0xc2,0xec,0xb1,0xc8,
    0xbd,0xe3,0x54,0x89,0xbf,0x48,0x1d,0x84,0x0f,0xdc,0x1a,0x9d,0xcb,0xce,0x10,0x9a,
    0x75,0x2e,0x1c,0x36,0xae,0xa4,0x96,0x70,0x40,0x62,0x3a,0x29,0x62,0x57,0x8a,0xee,
    0x38,0xa5,0x6e,0x13,0x9a,0x56,0x1e,0x01,0x16,0x4a,0x41,0xd0,0x38,0x74,0x57,0x19,
    0x08,0x47,0x54,0x05,0xd5,0x6a,0x8d,0xaa,0x31,0xb3,0xd8,0x98,0x3d,0x53,0xef,0xae,
    0x27,0x4e,0x16,0x33,0xf0,0x2f,0xfe,0x22,0x73,0xf9,0xe8,0xc4,0xa3,0x60,0x0d,0x84,
    0x14,0x39,0x3e},
        /*TST_DataSize*/
    131,
    },
    {
        /*TST_Name*/
        {"ATP test PassAuthObject-15 byte then 1514 byte passwords"},
        /*TST_MasterPassword*/
        {0xe9,0xa7,0xac,0x15,0xe0,0x1d,0x78,0x63,0x1b,0x3c,0xea,0xe0,0x72,0x0e,0x36,0xf7,
        0x73,0x73,0x07,0xc0,0xaa,0x5e,0xd9,0xd1,0x20,0x41,0xa3,0x57,0x21,0xc6,0xba,0x65,
        0x42,0xc0,0xf2,0x8b,0xa3,0x61,0x06,0xab,0x72,0xad,0x3a,0x08,0xb0,0x2e,0x3e,0xa0,
        0x38,0xea,0x56,0xbc,0xfd,0x92,0xb8,0xc5,0x93,0xfc,0x35,0x59,0xf1,0xd3,0x1c,0x9e,
        0x75,0x8e,0x5c,0xd6,0x28,0x9e,0xe8,0x34,0x44,0xec,0x60,0xee,0xf3,0x82,0xed,0x94,
        0x5a,0x88,0x6d,0xa0,0xd6,0x73,0xd0,0x4e,0x85,0x79,0xc1,0xae,0x09,0x48,0x89,0xf7,
        0x88,0xf7,0x31,0x1e,0xf7,0x3d,0xe7,0xa7,0x99,0xe1,0xa4,0xbc,0xc2,0x71,0x0b,0x7c,
        0xe1,0x37,0x93,0x95,0xbd,0x69,0xe8,0x15,0xff,0xa0,0x8f,0x7d,0xf1,0x8b,0xc9,0x17,
        0x85,0xe5,0xbb,0x8a,0x99,0xa4,0xcb,0xac,0x79,0x74,0x4d,0x97,0xa6,0x63,0x5f,0xff,
        0xd6,0xde,0x11,0xc3,0x3b,0xdc,0xca,0xc1,0x08,0x59,0xe7,0xef,0x32,0x06,0xa4,0xa8,
        0x73,0x3f,0x40,0x43,0x95,0x3d,0x5c,0xea,0xed,0x8d,0xa5,0xa9,0x26,0xc0,0xb2,0xc6,
        0x40,0x65,0x2f,0x51,0xd7,0x34,0x3c,0xfb,0xa9,0x8c,0x10,0x2c,0x53,0x20,0xe2,0x4f,
        0x5b,0xed,0x09,0x71,0x73,0x6f,0x62,0x0a,0xfc,0x14,0xf2,0x1a,0xca,0xf1,0xcc,0x78,
        0x27,0xb3,0x35,0x67,0x1a,0xd9,0x07,0x6b,0xe9,0x21,0x53,0x5b,0xdc,0x40,0x4a,0xb6,
        0x44,0xd6,0x5e,0x3a,0xbc,0xa1,0xa4,0xb3,0xaf,0xf1,0x7d,0x12,0x1a,0x5c,0x75,0xbe,
        0x93,0xb2,0x6b,0x2f,0x8b,0x34,0xf3,0xb8,0xd0,0x00,0xf8,0xa4,0x55,0xd0,0xa6,0x85,
        0x36,0xe4,0x86,0xc9,0xf7,0x3d,0xeb,0x8e,0x0d,0x0c,0x8e,0xb8,0x9f,0x6a,0x75,0x40,
        0x8d,0x49,0x19,0xce,0xb2,0xab,0xc7,0x8b,0x66,0x12,0x47,0x30,0x47,0x37,0xbc,0x64,
        0x3a,0xfe,0xcb,0x44,0xac,0xaa,0xff,0x43,0x1e,0x4d,0x6c,0x34,0xe0,0x83,0x93,0xa5,
        0x1c,0x60,0x86,0x6f,0x17,0xa7,0x4d,0x8b,0xb4,0x3d,0x87,0x27,0x3a,0xdd,0x54,0xf9,
        0x56,0x0c,0x73,0xd4,0x64,0x50,0xa8,0x79,0xea,0x9d,0x61,0xaf,0x65,0x10,0x98,0x96,
        0x49,0xe0,0xfb,0x38,0x43,0x91,0x4b,0x61,0xc1,0x6a,0x02,0xb1,0xb4,0x2a,0x38,0xef,
        0x94,0xf7,0xc7,0xa0,0xa5,0x97,0xae,0xd8,0x7a,0xe2,0xb3,0x51,0xb7,0x77,0x4d,0xba,
        0x1b,0xaf,0xc0,0x51,0xbd,0xcf,0x8a,0xb4,0x95,0x82,0xfe,0xf4,0x3f,0x86,0x2f,0xec,
        0xfc,0xa5,0x0f,0xd1,0xfa,0xe7,0xd8,0x0a,0xd5,0x06,0xab,0x41,0x5d,0x22,0x77,0xba,
        0x9a,0xb6,0x1d,0xe3,0x0d,0xcb,0xd2,0x2d,0x39,0x6b,0xc4,0x1b,0x62,0x59,0x00,0x98,
        0x95,0xff,0x93,0x8e,0xe8,0xa8,0xef,0xb4,0x03,0xef,0x91,0xa8,0xdf,0x77,0xe1,0x3d,
        0xce,0xdd,0x5a,0x16,0xbc,0xeb,0xea,0x74,0xb4,0x0f,0x9c,0x4c,0xa6,0x0b,0x74,0x9d,
        0x67,0xed,0x9a,0x00,0xf9,0x42,0xbc,0x81,0x0d,0x87,0xad,0xad,0xc6,0xe0,0x52,0xec,
        0xc0,0x0d,0xbe,0x11,0x51,0x99,0x9c,0x30,0x0e,0x54,0xcd,0xaf,0x91,0x04,0x53,0xa0,
        0x7a,0x58,0x6e,0x4e,0xb4,0x1d,0x04,0x16,0xfa,0xb4,0x46,0x79,0x99,0xc4,0x91,0x6f,
        0x77,0x2c,0x92,0xfd,0x54,0x3c,0xae,0x09,0x50,0x24,0xa1,0x6e,0xad,0xac,0x65,0x4c,
        0xd7,0x26,0x55,0xa1,0xa1,0xa1,0x92,0x1e,0xd2,0x60,0xa6,0x33,0xe0,0x8b,0x67,0x6d,
        0xfb,0x23,0x1e,0x01,0x4d,0x3b,0xe9,0xa9,0x81,0x66,0x5e,0xae,0x82,0x6c,0x71,0x46,
        0x85,0x41,0x98,0x21,0x49,0x37,0x2d,0x3f,0x9d,0x72,0x13,0x04,0x24,0x9c,0x9c,0x8e,
        0x55,0xdb,0xaa,0x46,0xc5,0x00,0x15,0xb5,0xa9,0x02,0x4d,0x9a,0x96,0xaa,0x41,0x39,
        0x8c,0x8f,0x7f,0xf5,0x33,0x45,0x9c,0x21,0x64,0xd2,0xd6,0x14,0xeb,0x61,0xf8,0x7b,
        0x8c,0x3b,0x7e,0xf4,0x44,0xf2,0xfa,0xd8,0xd0,0xdf,0xb6,0x57,0x74,0xcf,0x9b,0xcb,
        0xf5,0xfa,0x51,0x46,0xe7,0x35,0xa8,0x6d,0x2f,0x68,0x37,0x8a,0xc0,0x41,0x43,0xdc,
        0xa8,0x2a,0xe2,0x32,0x50,0x79,0x5f,0xb8,0xff,0xe7,0xe1,0x10,0xa1,0x44,0x48,0xa4,
        0xc7,0x69,0x58,0x3b,0xee,0x6d,0x19,0xcb,0x04,0x1c,0x7d,0x8e,0x28,0xa4,0x44,0x58,
        0xb2,0x92,0x1d,0x28,0x73,0xfd,0x0e,0xfd,0x3e,0x01,0x15,0xeb,0xa6,0x70,0x10,0x6d,
        0x0a,0xc3,0xda,0xfd,0xcf,0x57,0xb7,0xe2,0xed,0xd6,0xf2,0x4a,0xad,0xf2,0xc4,0x98,
        0xb1,0x5a,0x78,0xff,0x34,0xe6,0xcd,0x50,0x93,0x15,0x9c,0x10,0x0c,0xba,0xba,0xce,
        0xc6,0xf2,0x20,0xb3,0x12,0x59,0x49,0x5b,0xf1,0x7e,0xdc,0xe3,0xd6,0x94,0x8b,0x44,
        0xad,0x6a,0x3b,0xdf,0x1b,0x9d,0x65,0x59,0x08,0x0c,0xbc,0xa8,0x5b,0x8c,0x10,0x6e,
        0x04,0xdd,0x72,0x86,0x40,0xdd,0x99,0xdd,0x18,0xfc,0x84,0x84,0x2b,0xf0,0x61,0x03,
        0xae,0xaa,0xae,0xef,0xb1,0x88,0x9e,0xbf,0xa4,0xcc,0xbe,0xdb,0x19,0x4d,0xd8,0xf6,
        0xcc,0x6c,0x17,0x9e,0xe0,0x4a,0x6d,0x11,0x6b,0x38,0x32,0x53,0x35,0x6f,0x0e,0x7d,
        0xbd,0x02,0x18,0x58,0x7d,0x10,0x3f,0x2a,0x6f,0x3e,0xea,0xd0,0xd0,0x64,0xdb,0x0d,
        0x24,0x87,0x59,0x22,0x7a,0x08,0x8e,0x9f,0xf1,0x1a,0x2e,0x78,0x7b,0x79,0x59,0x5b,
        0xe1,0x5a,0xc3,0x41,0x08,0x9d,0x12,0x44,0x72,0x4a,0x87,0xb0,0x07,0x3b,0xe1,0x5c,
        0x16,0x16,0x7e,0x3b,0x97,0x7f,0xc4,0x2e,0xb3,0x8b,0xbf,0x1c,0x86,0x77,0x0b,0x45,
        0x23,0x9a,0xf5,0xd3,0xd8,0x98,0xdd,0xb2,0xb4,0xd9,0xdf,0xa2,0x47,0x39,0xb2,0x8b,
        0xa9,0x01,0xcf,0x10,0xbe,0x17,0xd6,0x66,0xb7,0x71,0x2e,0x67,0xdc,0xcf,0xec,0xe2,
        0x89,0xaa,0xf7,0x36,0x77,0x67,0x69,0x1f,0x3d,0xd1,0x38,0xcf,0x17,0xc6,0x15,0x41,
        0xe5,0x30,0x94,0xca,0x77,0x38,0x8e,0xf1,0x07,0xb6,0xc4,0x80,0x07,0xeb,0xc4,0xdb,
        0x1e,0x72,0x11,0x91,0x6d,0x74,0x7e,0x31,0x16,0x1c,0xdb,0x5f,0xff,0x4a,0xd3,0x26,
        0xd3,0x8c,0x15,0x90,0x4a,0x4a,0xb2,0x74,0xab,0x40,0xc6,0x90,0x8f,0x31,0x5b,0xd7,
        0xe7,0xda,0x8a,0x0c,0x40,0x26,0xe3,0x90,0x46,0xa0,0x10,0x79,0x87,0x2d,0xb4,0xe3,
        0x7a,0xfb,0x99,0x8b,0xc0,0xb5,0x0b,0x9a,0xa9,0xf9,0x7f,0xbe,0xfa,0x0b,0x79,0x7f,
        0xee,0xcb,0xac,0xd1,0x7a,0xe4,0x62,0xe5,0xd5,0x47,0x1e,0x45,0x38,0xd8,0x80,0x20,
        0xe3,0x66,0x6a,0xe2,0x60,0xe1,0x61,0x08,0x0b,0xc7,0x36,0x33,0xd2,0xe0,0xe5,0x7b,
        0x3a,0x2b,0xbd,0x05,0xa2,0x18,0xc1,0xd8,0xcc,0xf7,0x4f,0xec,0x99,0xb1,0xff,0x84,
        0x14,0xb6,0xce,0xbe,0xb2,0x36,0x7c,0x69,0xd9,0x94,0x32,0x16,0x9e,0x18,0x68,0x72,
        0xd3,0xe4,0x06,0xd3,0x41,0x29,0xc9,0x10,0x32,0x9a,0xe9,0x96,0x33,0x21,0xf9,0xb8,
        0x17,0xd1,0x0e,0x47,0x3f,0x1d,0x23,0x63,0x19,0x47,0xbc,0x90,0xe7,0x1b,0xca,0x0d,
        0xc2,0xdc,0xcf,0x61,0xde,0x7f,0x42,0x36,0x0f,0x17,0x35,0x6a,0x8c,0x91,0x35,0x64,
        0xf4,0xa1,0x72,0xa4,0x8e,0xfc,0x20,0x9e,0xd5,0xc8,0x1c,0xc9,0x34,0x50,0xd3,0xf3,
        0x0e,0xfd,0x60,0xd7,0x01,0x82,0xf4,0xf1,0x6c,0x56,0x7b,0x91,0x2e,0x67,0x7c,0x2f,
        0xb1,0x0d,0x41,0xfe,0x28,0x3c,0x39,0xc3,0x14,0xff,0x9a,0xe8,0x0d,0x21,0x4a,0xcc,
        0xbf,0x2d,0x00,0x5e,0x33,0x9a,0xa7,0xea,0x50,0x3f,0x03,0x33,0xa1,0x0d,0x96,0xc1,
        0x58,0xfc,0xc5,0x7c,0x93,0x46,0x37,0x7a,0xdf,0xd4,0x7e,0x16,0xfa,0xf5,0xf9,0x42,
        0xde,0x56,0xf8,0x1e,0xfa,0x2f,0x22,0xc9,0xc3,0xba,0x14,0x76,0x6b,0xe9,0x4b,0xc3,
        0xf0,0x58,0x44,0x47,0x59,0x81,0xe1,0x6a,0x3d,0x2f,0x0f,0x7a,0x84,0x35,0xa6,0xfb,
        0x71,0x5f,0x91,0x3e,0xe1,0xa9,0x2e,0x35,0xcd,0xaf,0xf7,0x85,0x16,0x65,0x63,0xdd,
        0x82,0x08,0x07,0x86,0x01,0x54,0x01,0x3c,0x36,0xf8,0x96,0x3d,0x32,0x47,0x1a,0x9f,
        0x83,0x30,0x10,0xe6,0x6d,0x70,0x93,0xd6,0x77,0x06,0xf5,0x86,0x2a,0xe7,0xa5,0xb6,
        0x15,0xf4,0x56,0x62,0x14,0x29,0x5d,0x98,0xd2,0x17,0x5b,0x86,0x8d,0x94,0x1d,0xd7,
        0x19,0xb1,0xc0,0x40,0x28,0xec,0x19,0x55,0xc8,0xa7,0x54,0xa2,0x2d,0xd9,0xda,0xf7,
        0xb1,0x04,0x79,0x03,0x19,0x67,0xbf,0x24,0x1a,0x74,0xa6,0x7e,0x1c,0x84,0x77,0x4b,
        0x3d,0xca,0xe8,0x71,0x99,0x85,0x87,0x5a,0xc9,0x7a,0x5c,0x00,0xa9,0xa2,0xca,0x47,
        0x5e,0x20,0xb7,0x90,0x98,0x75,0xed,0x8b,0x15,0xf7,0xbf,0x4c,0x67,0x80,0xef,0xa2,
        0xf6,0x63,0xcf,0xa4,0x48,0xa4,0xa7,0x8c,0x80,0x68,0x57,0xc9,0x25,0xaa,0x3d,0x4f,
        0x25,0x30,0x59,0x32,0x1a,0xbd,0xaf,0x73,0xcb,0x89,0xed,0x1a,0xf6,0xee,0x4e,0x84,
        0x4d,0x64,0xbe,0xff,0xbe,0xaf,0x3f,0x94,0xf7,0x57,0x8b,0x24,0x2a,0x59,0xfb,0xb7,
        0x0d,0x1c,0xa7,0x10,0x26,0xa6,0xcf,0x85,0x45,0x10,0x7a,0x0d,0x52,0x37,0x5c,0x9b,
        0x48,0xb5,0xfd,0xaa,0x82,0x10,0x18,0x19,0x36,0x30,0x41,0x3a,0x3f,0x17,0xcb,0x26,
        0x1f,0xcc,0xe9,0x53,0x44,0x98,0x13,0x68,0x8a,0x75,0xac,0x4f,0x02,0xc4,0xe1,0x8c,
        0xf2,0x3e,0xd4,0xce,0x1c,0x2d,0xfa,0xc4,0x43,0xdc,0xc1,0x32,0xec,0x4c,0x77,0x44,
        0x62,0x28,0x67,0x22,0xfc,0xfb,0x45,0xc4,0xa2,0xa1,0xcc,0x08,0x8e,0xfc,0xa5,0x02,
        0x50,0xe8,0x8b,0x93,0x15,0x70,0xad,0x3d,0x28,0x42,0x53,0x35,0xb9,0x60,0xc5,0xba,
        0xde,0x19,0x69,0xa6,0xd7,0x38,0x2b,0x43,0x96,0x7b,0x21,0x5f,0x7f,0x46,0x6f,0xa3,
        0x6c,0x99,0x69,0x20,0xf4,0x40,0xf8,0x2b,0xed,0x49,0x3f,0x6b,0x2f,0xbb,0x7e,0x30,
        0x9b,0x85,0x36,0x06,0x5c,0xb5,0x8e,0x8b,0x6d,0xea},
        /*TST_MasterPasswordSizeInBytes*/
        1514,
        /*TST_MasterMaxNumOfTrials*/
        2,
        /*TST_SecondaryPassword*/
        {0x90,0x9e,0x66,0xe2,0xe0,0xc5,0xef,0x95,0x27,0x12,0xdd,0x88,0x4c,0xe3,0xe7},
        /*TST_SecondaryPasswordSizeInBytes*/
        15,
        /*TST_SecondaryMaxNumOfTrials*/
        6,
    /*TST_NewSecondaryPassword*/
    {0x6f,0xd3,0x3c,0x2e,0x07,0xe5,0xba,0xd7,0xdf,0x20,0x04,0x50,0xb7,0x13,0xf8,0x48,
    0x8b,0x9b,0x95,0x18,0x68,0x61,0x6b,0x5e,0x7f,0xa3,0x50,0xe7,0x78,0x38,0x55,0xd3,
    0x08,0xce,0xf9,0xf3,0xc6,0x77,0x9c,0x76,0x3a,0x64,0x36,0xc5,0x37,0xef,0x48,0xab,
    0x6b,0xdf,0x13,0xb9,0x35,0xe8,0x09,0xe9,0xb6,0x72,0x81,0x81,0x2b,0x9c,0xae,0x3a,
    0x7a,0x7f,0xd2,0xa2,0x0a,0xb7,0xaf},
    /*TST_NewSecondaryPasswordSizeInBytes*/
    71,
    /*TST_NewSecondaryMaxNumOfTrials*/
    7,
    /*TST_Data*/
    {0x8c,0x13,0x8b,0xa9,0xae,0xb6,0xc7,0xcc,0x02,0xc0,0xd5,0x5c,0x61,0xb7,0xf3,0x33,
    0x8c,0x68,0x90,0x91,0x11,0x34,0x53,0x11,0x73,0xab,0x5f,0xdc,0x85,0x5c,0xd6,0x1d,
    0x17,0xea,0x9b,0xb5,0xd4,0x63,0x5d,0x2f,0x6b,0xce,0xd1,0xf6,0xed,0x03,0x3e,0xc5,
    0x76,0xc0,0x3f,0x60,0x10,0xf8,0xc5,0x82,0xd4,0x6e,0x5b,0x16,0x53,0x83,0xae,0xa9,
    0x34,0x4c,0x4c,0x20,0x1e,0xe8,0xac,0xa6,0xd8,0x11,0x6f,0xe9,0xae,0xf0,0xe5,0x86,
    0x17,0x36,0xd3,0xc1,0x96,0x68,0x73,0x7a,0xde,0x7a,0xbd,0x5d,0x39,0xa0,0xe5,0x58,
    0x2a,0x61,0x25,0x52,0x51,0xed,0xbc,0x1a,0x90,0xb0,0x37,0x9d,0x6c,0x27,0xef},
    /*TST_DataSize*/
    111,
    },
#endif
};
/**************************************/
/* RSA Authenticator object Test data */
/**************************************/
TST_ATP_RsaAuthTestDataStruct TST_ATP_RsaAuthObjectTestData[]=
{

   {
        /*TST_Name*/
        {"ATP test RsaAuthObject-2048byte key"},
        /*TST_N*/
        {0x99,0x3f,0x7c,0x0d,0xef,0xcf,0x72,0x5a,0xdf,0x45,0x5a,0x4b,0x26,0xb9,0xb2,0xb2,
        0x3e,0x69,0x15,0x99,0x81,0x71,0xce,0x64,0x8a,0x2c,0x52,0xe7,0xbe,0x6b,0x18,0x41,
        0xaa,0x25,0x34,0x71,0x39,0x90,0xd5,0x44,0x53,0xc0,0x42,0xb5,0x60,0xb4,0x69,0x4f,
        0x3a,0x32,0x09,0xfe,0x54,0xfc,0x7c,0xe7,0xa8,0xe6,0x23,0x6c,0x66,0xb4,0x72,0x98,
        0xc5,0x93,0x7e,0x52,0xf8,0xc0,0x96,0x94,0xbc,0xe6,0xc9,0xd3,0xd4,0x84,0x27,0x4c,
        0x11,0xab,0x89,0x9d,0x3d,0xda,0x5d,0x33,0x73,0xb7,0x91,0xb7,0xb0,0x67,0x13,0xfe,
        0xd1,0x8b,0xa3,0xdb,0x8d,0xe6,0x2a,0xee,0x74,0xda,0x4f,0xa3,0x0a,0xcf,0xcc,0x3e,
        0x33,0x76,0xbe,0xf8,0x5f,0xf9,0x3d,0x90,0x06,0x2a,0x4d,0x08,0xd2,0xd2,0xd3,0xd8,
        0x8b,0x26,0xa9,0xbc,0x8b,0x74,0x9b,0xfd,0x4f,0xb9,0x1b,0x13,0xbc,0x5f,0xe4,0xbd,
        0x0e,0x06,0xe7,0x79,0x7d,0x85,0x45,0x29,0x80,0xb7,0x6c,0x14,0x9c,0x63,0x6d,0xab,
        0xe0,0xa2,0xfe,0x09,0x7a,0xae,0xbf,0x7d,0x54,0x39,0x3d,0x39,0x3e,0x6f,0x83,0x36,
        0x81,0x9f,0xdf,0x9f,0xe6,0x0c,0xfa,0x5f,0x0f,0x7e,0x65,0xbb,0xa1,0x78,0xb8,0xd4,
        0x57,0xf8,0x07,0xd4,0xa4,0xbf,0x5f,0x21,0x14,0x13,0x39,0x1f,0xf3,0x17,0x83,0xf2,
        0x8c,0xb4,0x40,0xbe,0x2c,0xfd,0xe1,0x33,0x67,0x07,0x92,0x89,0x38,0xdf,0x04,0xfa,
        0x87,0x45,0x86,0xe6,0xb7,0x81,0x27,0xd2,0xab,0x73,0x58,0x19,0xc6,0x9d,0xa4,0xf6,
        0xb9,0x7f,0x22,0x5c,0x61,0x8a,0x2a,0xf0,0x4a,0x6e,0x26,0xd2,0x8c,0x5d,0x87,0x7f},
        /*TST_NSizeInBytes*/
        256,
        /*TST_D*/
        {0x26,0x8e,0x93,0x7e,0xca,0x2c,0x6e,0x80,0x30,0x96,0xb9,0x6e,0x19,0x13,0x35,0xc3,
        0xa4,0xf2,0x39,0x8e,0x02,0xc4,0x88,0x82,0x41,0x45,0x7f,0xa2,0x71,0x05,0x6e,0xf7,
        0xee,0x80,0x27,0xde,0xa8,0xf6,0x28,0xc2,0x65,0x34,0x05,0x54,0xaf,0x3d,0x15,0x15,
        0xea,0xf5,0x76,0x10,0x38,0x7f,0xc2,0x49,0x62,0xf4,0x6c,0x4b,0x34,0xd8,0x07,0xd1,
        0x2a,0x3c,0xbe,0xd6,0xcf,0x61,0x5d,0x41,0x94,0xf9,0x98,0x24,0x24,0xdf,0x0f,0x28,
        0x13,0x76,0x0e,0x4c,0xb2,0xa8,0x43,0x34,0xd3,0xd3,0x86,0xe5,0x29,0x8b,0xf5,0xba,
        0xf2,0x2b,0xe9,0x11,0x2f,0x75,0x8e,0xad,0xaa,0x56,0xd7,0x1c,0x95,0x76,0xcc,0xd3,
        0x85,0x8d,0x45,0xe5,0x25,0xf8,0x86,0xa5,0xba,0xf7,0x5f,0xa4,0x6d,0xae,0xbf,0xbf,
        0xe3,0x28,0x6e,0x4f,0x0f,0x47,0x6f,0x6e,0x07,0x28,0xee,0x3f,0x48,0xc3,0x5d,0x59,
        0xe9,0x60,0xdb,0x82,0x3e,0xe5,0xc8,0x7d,0x26,0x89,0x38,0x26,0x64,0xf2,0xca,0xcf,
        0x97,0x70,0x1d,0xbd,0xf8,0x3f,0xf3,0x45,0x59,0xbb,0x70,0xb2,0x4c,0x1e,0x35,0x4a,
        0x2c,0xd6,0xbd,0x08,0x27,0x7c,0x7a,0x24,0x5c,0x49,0x64,0x5d,0xd7,0x4c,0x8c,0x96,
        0xaf,0x80,0xc1,0x80,0x1a,0x28,0xdd,0x7d,0xc5,0x43,0xc8,0xc3,0x1a,0x3b,0x4a,0xc8,
        0x01,0xfc,0x87,0xcb,0x7e,0x0a,0xf3,0xb9,0x9e,0xdd,0x1a,0x0c,0x99,0xd0,0x56,0xb9,
        0x3a,0xc6,0x40,0xd0,0x31,0xc5,0x10,0xc1,0xf1,0xb7,0xcd,0x05,0xf0,0x2e,0x8f,0x47,
        0x1b,0x35,0x56,0x2e,0x39,0x9a,0x34,0xe7,0xf6,0x49,0x7e,0x75,0x84,0x9b,0x4d,0x11},
        /*TST_NSizeInBytes*/
        256,
        /*TST_E*/
        {0x01,0x00,0x01},
        /*TST_ESizeInBytes*/
        3,
        /*TST_ChallengeBuff*/
        {0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d,
        0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d},
        /*TST_ChallengeBuffsize*/ 
        32,
        /*TST_NewChallengeBuff*/  
        {0x6a,0xd5,0x1b,0xa6,0x1b,0xec,0x9c,0x0f,0x62,0xd9,0xd2,0xb9,0xc1,0xe6,0x6d,0xe6,
        0x82,0x05,0x25,0xba,0x4c,0x14,0xf4,0x9e,0xf5,0x5f,0x82,0xe3,0x97,0x67,0xe1,0xa7},
        /*TST_NewChallengeBuffSize*/
        32,
        /*TST_SignedChallengeBuff*/
        {0x00},
        /*TST_SignedChallengeBuffSize;*/
        256,
        /*TST_Data*/
        {0xc9,0x69,0xdb,0x3f,0xda,0xe7,0x95,0xbe,0x98,0x39,0x38},
        /*TST_DataSize*/
        11,
        },
};
#if TST_USE_AUTHENTICATOR_MODULE
/******************************************/
/* AES key Authenticator object Test data */
/******************************************/

TST_ATP_AesKeyAuthTestDataStruct TST_ATP_AesKeyAuthObjectTestData[]=
{
    {
        /*TST_Name*/
        {"ATP test AesKeyAuthObj-128bit key"},
        /*TST_AesKey*/
        {0x20,0x76,0x91,0x5c,0x52,0x5e,0xa3,0x0b,0xdc,0x3f,0xc7,0x8b,0xd5,0x21,0xf4,0xca},
        /*TST_KeySizeInBytes*/
        16,
        /*TST_ChallengeBuff*/
        {0x9f,0xed,0xd0,0x32,0x9e,0x90,0x4b,0xd5,0xb7,0x85,0xed,0xaf,0x2e,0x4f,0x3b,0xfb,
        0xe3,0xa4,0x29,0xb1,0x81,0xcb,0xeb,0x05,0xf9,0x48,0x08,0x30,0x2f,0xbb,0xb0,0x74},
        /*TST_ChallengeBuffSize*/  
        32,
        /*TST_NewChallengeBuff*/
        {0xe3,0xa4,0x29,0xff,0x81,0xcb,0xeb,0x00,0xf9,0x48,0x00,0x30,0x2f,0xbb,0xaa,0x74,
        0xe3,0xa4,0x29,0xff,0x81,0xcb,0xeb,0x00,0xf9,0x48,0x00,0x30,0x2f,0xbb,0xaa,0x74},
        /*TST_NewChallengeBuffSize*/ 
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_EncChallengeBuffSize*/
        32,
        /*TST_Data*/
        {0x7e,0x0f,0x0a,0xff,0x9e,0xb8,0x39,0x3f,0xbe,0xf9,0xd2,0xa0,0x58,0x35,0x3d,0x3c,
        0x2e,0xf8,0x6b,0x8e,0xdd,0x36,0x0d,0xd8,0xb5,0xd3,0x04,0xc1,0xc8,0x68,0x19,0x43,
        0x41,0x45,0xef,0xc4,0xf8,0xb2,0x35,0x83,0x43,0x7b,0x20,0x36,0x0e,0xab,0x19,0xf2,
        0x2e,0x97,0xb3,0x4a,0xf2,0x1e,0xdf,0xbb,0xfb,0x30,0x63,0x48,0x4e,0x8d,0x88,0x61},
        /*TST_DataSize*/
        64,    
    },
};



/**************************************/
/* ECC Authenticator object Test data */
/**************************************/
TST_ATP_ECCAuthTestDataStruct TST_ATP_ECCAuthObjectTestData[]=
{
   {
       /*TST_Name*/
       {"ATP test ECCKeyAuthObj-secp256r1 domain"},
       /*TST_ExternalPublKey*/
       {0x04,
       0x4e,0x70,0x81,0xa8,0x89,0xb6,0x26,0x9e,0xd6,0xad,0xa9,0xa2,0x5a,0xa4,0x9b,0x9f,
       0x47,0x85,0x01,0x53,0xe3,0x41,0xdb,0xa9,0xa1,0x9f,0xfa,0xbe,0xe0,0xf7,0xe6,0x50,
       0xcb,0x2a,0x00,0x0a,0x54,0x21,0x70,0x4b,0x6c,0xfb,0x79,0xe1,0xe3,0x0f,0xc7,0x23,
       0xf3,0x00,0x4a,0x12,0x7e,0xa8,0x5b,0xb9,0xd1,0x9e,0x46,0x75,0xf7,0x06,0xb0,0x2f},
       /*TST_ExternalPublKeySize*/
       65,
       /*TST_ExternalPrivKey*/
       {0x3e,0xa3,0x6f,0x17,0xa6,0x1a,0x2b,0xeb,0xff,0xba,0x58,0x3d,0xb5,0x9a,0x0c,0xd0,
       0x0a,0xff,0x50,0x25,0xab,0xbc,0xdb,0x6b,0x1b,0xe8,0x2c,0xe4,0x51,0xcf,0x3c,0x9b},
       /*TST_ExternalPrivKeySize*/
       32,
       /*TST_ChallengeBuff*/
       {0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d,
       0x28,0xa4,0xd5,0x49,0x05,0xf8,0x5c,0x69,0xca,0x79,0xa1,0x7e,0x1e,0x0c,0x88,0x2d},
       /*TST_ChallengeBuffsize*/ 
       32,
       /*TST_NewChallengeBuff*/  
       {0x6a,0xd5,0x1b,0xa6,0x1b,0xec,0x9c,0x0f,0x62,0xd9,0xd2,0xb9,0xc1,0xe6,0x6d,0xe6,
       0x82,0x05,0x25,0xba,0x4c,0x14,0xf4,0x9e,0xf5,0x5f,0x82,0xe3,0x97,0x67,0xe1,0xa7},
       /*TST_NewChallengeBuffSize*/
       32,
       /*TST_SignedChallengeBuff*/
       {0x00},
       /*TST_SignedChallengeBuffSize*/
       64,
       /*TST_Data*/
       {0x7e,0x0f,0x0a,0xff,0x9e,0xb8,0x39,0x3f,0xbe,0xf9,0xd2,0xa0,0x58,0x35,0x3d,0x3c,
       0x2e,0xf8,0x00,0x8e,0xdd,0x36,0x0d,0xd8,0xb5,0xd3,0x04,0xc1,0xc8,0x68,0x19,0x43,
       0x41,0x45,0xef,0xc4,0xf8,0xb2,0x35,0x83,0x43,0x7b,0x20,0x36,0x0e,0xab,0x19,0xf2,
       0x2e,0x97,0xb3,0x4a,0xf2,0x1e,0xdf,0x00,0xfb,0x30,0x63,0x48,0x4e,0x8d,0x88,0x61},
       /*TST_DataSize*/
       64, 
   },
};

const int TST_NumberOf_PassAuthObjectTests = sizeof(TST_ATP_PassAuthObjectTestData)/sizeof(TST_ATP_PassAuthObjectTestData[0]);
#endif
#if TST_USE_AUTHENTICATOR_MODULE
const int TST_NumberOf_RsaAuthObjectTests = sizeof(TST_ATP_RsaAuthObjectTestData)/sizeof(TST_ATP_RsaAuthObjectTestData[0]);
const int TST_NumberOf_AesKeyAuthObjectTests = sizeof(TST_ATP_AesKeyAuthObjectTestData)/sizeof(TST_ATP_AesKeyAuthObjectTestData[0]);
const int TST_NumberOf_ECCAuthObjectTests = sizeof(TST_ATP_ECCAuthObjectTestData)/sizeof(TST_ATP_ECCAuthObjectTestData[0]);
#endif



